#!/bin/bash

. /vagrant/shell/portal-admin/portal.dev.profile

read -r -d '' APACHE_CONF << EOM


<IfModule mod_proxy.c>
        ProxyRequests Off
        <Proxy *>
                Order allow,deny
                Allow from all
        </Proxy>
        
        ProxyPassMatch ^/mhv-portal-admin/(.*)$ ajp://IP:PORT/web/mhv-portal-admin/REPLACE_ME
        ProxyPass / ajp://IP:PORT/
        ProxyPassReverse / ajp://IP:PORT/
        
</IfModule>

EOM

read -r -d '' PORTAL_EXT_CONF << EOM


# HTTP Proxy Settings
web.server.http.port=PORT
web.server.https.port=PORT

EOM


# make sure httpd is installed
if [ $(sudo yum -q list installed httpd | grep -c "httpd") -ne 1 ] 
then
	if [ $(sudo yum -y install httpd | grep -c "Complete!") -ne 1 ] 
	then
		exit "Error installing Apache httpd service.";
	fi
fi

# copy custom configuration to server.
if [ $(sudo grep -c "mhv-portal-admin" /etc/httpd/conf/httpd.conf) -ne 1 ]
then
	sudo su -c "echo \"$APACHE_CONF\" >> /etc/httpd/conf/httpd.conf"
	sudo su -c "sed -i.bak 's/REPLACE_ME/\$1/g' /etc/httpd/conf/httpd.conf"
fi

# copy custom portal-ext.properties to the correct location
if [ $(sudo grep -c "HTTP Proxy Settings" ${LIFERAY_HOME}/portal-ext.properties) -ne 1 ]
then
	sudo su -c "echo \"$PORTAL_EXT_CONF\" >> ${LIFERAY_HOME}/portal-ext.properties"
fi 

# make sure httpd is running
if [ $(sudo service --status-all | grep -c "httpd .* is running...") -ne 1 ] 
then
	sudo service httpd start
else
	sudo service httpd restart
fi

exit;
